package gov.va.vinci.dart.dms.db.mock;

import java.util.HashMap;

import gov.va.vinci.dart.dms.biz.Repository;
import gov.va.vinci.dart.dms.db.RepositoryDAO;

public class RepositoryDAOMock implements RepositoryDAO {

	private static HashMap<Integer,Repository> IDHash = new HashMap<Integer,Repository>();
	private static boolean initialized = false;

	@Override
	public Repository findById(int repositoryId) {
		initializeRepositoryHash();
		
		return IDHash.get(repositoryId);
	}

	private void initializeRepositoryHash() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		Repository repo = new Repository();
		repo.setId(1);
		repo.setName("Repository One");
		repo.setLocation("c:/tmp");
		IDHash.put(1, repo);
	}
}
